<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"/><xsl:import href="../../../../date.xsl"/><xsl:import href="../../../../table.xsl"/><xsl:import href="../../../../style.xsl"/><xsl:import href="../../../../lien.xsl"/><xsl:variable name="page-format" select="portrait"/><xsl:output encoding="UTF-8" method="xml" indent="yes"/><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"/><xsl:param name="nomenclaturePasEnrichie"/><xsl:variable name="nomenclature" select="document('../libellePlanCompte.xml')/n:Nomenclature"/><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"/><xsl:variable name="isPrint" select="1"/><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"/><xsl:template match="/dcfu:CompteFinancierUnique"/><xsl:template match="/dcfu:CompteFinancierUnique">
      <html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
         
         <head>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
            <meta name="generator" content="ODM"/>
            
            
            <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css"/>
            
            <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css"/>
            
            <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:Calibri;
  panose-1:2 15 5 2 2 2 4 3 2 4;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoHeading8, li.MsoHeading8, div.MsoHeading8
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  page-break-after:avoid;
  font-size:12.0pt;
  font-family:"Times New Roman",serif;
  font-weight:bold;}
p.MsoHeader, li.MsoHeader, div.MsoHeader
  {
  margin:0in;
  margin-bottom:.0001pt;
  font-size:11.0pt;
  font-family:"Calibri",sans-serif;}
p.MsoFooter, li.MsoFooter, div.MsoFooter
  {
  margin:0in;
  margin-bottom:.0001pt;
  font-size:11.0pt;
  font-family:"Calibri",sans-serif;}
span.En-tteCar
  {
  }
span.PieddepageCar
  {
  }
span.Titre8Car
  {
  
  font-family:"Times New Roman",serif;
  font-weight:bold;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:297mm 210mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style></head>
         
         
         
      <body lang="EN-US"><xsl:variable name="Refer1">B31ORGAREGROUP</xsl:variable><xsl:variable name="Refer2" select="$docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:IdColl/@V"/><xsl:variable name="Refer3" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V"/><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="concat ($Refer1, '_', $Refer2, '_', $Refer3)"/></xsl:call-template><div id="header">
               
               <p class="MsoHeader"><b><span style="font-size:8.0pt;font-family: &quot;Arial&quot;,&quot;sans-serif&quot;"><xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:LibelleColl/@V)"/> - <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:EnTeteBudget/n:LibelleEtab/@V)"/> - <xsl:value-of select="distinct-values($data/data:NatureDecision/data:valeur[@value = concat($docbudg//n:Budget/n:BlocBudget/n:NatDec/@V,                         if ($docbudg//n:Budget/n:BlocBudget/n:ProjetBudget/@V = 'true') then '-proj' else '')]/text())"/>  - <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V)"/></span></b></p>
               
            </div><div class="WordSection1">
               
               <div align="center">
                  
                  <xsl:variable name="varOdmTmpTab1">
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        <tr style="page-break-inside:avoid;height:14.25pt">
                           <td width="85.3%" valign="top" style="border-top:double 1.5pt; border-left:double 1.5pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.55pt 0in 3.55pt;height:14.25pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&quot;Arial&quot;,sans-serif">I – INFORMATIONS GENERALES ET SYNTHÉTIQUES</span></b></p>
                              
                           </td>
                           <td width="14.7%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt;height:14.25pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&quot;Arial&quot;,sans-serif">I</span></b></p>
                              
                           </td>
                        </tr>
                        <tr style="page-break-inside:avoid;height:12.75pt">
                           <td width="85.3%" valign="top" style="border-top:none;border-left: double black 1.5pt;border-bottom:double black 1.5pt;border-right: solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt;height:12.75pt" rowspan="1" colspan="1">
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif">LISTE DES ORGANISMES DE REGROUPEMENT AUXQUELS ADHÈRE LA COLLÉCTIVITÈ</span></b></p>
                              
                           </td>
                           <td width="14.7%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt;height:12.75pt" rowspan="1" colspan="1">
                              
                              <p class="MsoHeading8"><span lang="FR" style="font-size:10.0pt;font-family:&quot;Arial&quot;,sans-serif">B3.1</span></p>
                              
                           </td>
                        </tr>
                     </table>
                  </xsl:variable>
                  <xsl:call-template name="table:outputTable">
                     <xsl:with-param name="table" select="$varOdmTmpTab1"/>
                  </xsl:call-template>
                  
               </div>
               
               <p class="MsoNormal" style="margin-right:2.55pt"><span lang="FR" style="font-size: 8.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
               
               <p class="MsoNormal" style="margin-right:-4.55pt;text-align:justify"><b><span lang="FR" style="font-family:&quot;Arial&quot;,sans-serif"> </span></b></p>
               
               <div align="center">
                  
                  <xsl:variable name="varOdmTmpTab2">
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><xsl:variable name="varOdm1" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:Annexes/n:DATA_ORGANISME_GROUP/n:ORGANISME_GROUP[(not(./n:Groupe/@V))]"/>
                        <thead>
                           
                           <tr height="0" class="#tech# #fixWidths#">
                              <td width="58.6%" style="border:none" rowspan="1" colspan="1"/>
                              <td width="12.2%" style="border:none" rowspan="1" colspan="1"/>
                              <td width="13.5%" style="border:none" rowspan="1" colspan="1"/>
                              <td width="15.7%" style="border:none" rowspan="1" colspan="1"/>
                           </tr>
                           
                           <tr style="page-break-inside:avoid">
                              <td width="58.6%" style="border-top:double 1.5pt;border-left: double 1.5pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt;border-color: black;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Désignation des organismes</span></b></p>
                                 
                              </td>
                              <td width="12.2%" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Date d’adhésion</span></b></p>
                                 
                              </td>
                              <td width="13.5%" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Mode de participation (1)</span></b></p>
                                 
                              </td>
                              <td width="15.7%" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Montant du financement</span></b></p>
                                 
                              </td>
                           </tr>
                           
                        </thead>
                        <tr style="page-break-inside:avoid">
                           <td width="100%" colspan="4" style="border-top:none;border-left: double black 1.5pt;border-bottom:solid black 1.0pt;border-right: double black 1.5pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Syndicats mixtes (article L. 5721-2 du CGCT)</span></b></p>
                              
                           </td>
                        </tr><xsl:variable name="varOdm2" select="$varOdm1[(./n:CodNatOrgGroup/@V='02')]"/>
                        <xsl:variable name="varOdm3">
                           <xsl:for-each select="$varOdm2"><xsl:sort select="./n:DtAdhGroup/@V"/><xsl:variable name="ligne" select="."/>
                              <tr style="page-break-inside:avoid">
                                 <td width="58.6%" style="border-top:none;border-left:double black 1.5pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                    <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($ligne/n:NomOrgGroup/@V)"/></span></p>
                                 </td>
                                 <td width="12.2%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                    <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($ligne/n:DtAdhGroup/@V)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p>
                                 </td>
                                 <td width="13.5%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                    <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($ligne/n:CodModFinanc/@V)"/></span></p>
                                 </td>
                                 <td width="15.7%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                    <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtFinancOrgGroup/@V"/></xsl:call-template></span></p>
                                 </td>
                              </tr>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm4">
                           <xsl:choose>
                              <xsl:when test="count($varOdm3/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="100%" colspan="4" rowspan="1" style="border-top:hidden;border-left: double black 1.5pt;border-bottom:solid black 1.0pt;border-right: double black 1.5pt;padding:0in 3.55pt 0in 3.55pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm3"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm4/xhtml:tr"/>
                        </xsl:call-template>
                        <tr style="page-break-inside:avoid">
                           <td width="100%" colspan="4" style="border-top:none;border-left: double black 1.5pt;border-bottom:solid black 1.0pt;border-right: double black 1.5pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">EPCI</span></b></p>
                              
                           </td>
                        </tr><xsl:variable name="varOdm5" select="$varOdm1[(./n:CodNatOrgGroup/@V='01')]"/>
                        <xsl:variable name="varOdm6">
                           <xsl:for-each select="$varOdm5"><xsl:sort select="./n:DtAdhGroup/@V"/><xsl:variable name="ligne" select="."/>
                              <tr style="page-break-inside:avoid">
                                 <td width="58.6%" style="border-top:none;border-left:double black 1.5pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                    <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($ligne/n:NomOrgGroup/@V)"/></span></p>
                                 </td>
                                 <td width="12.2%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                    <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($ligne/n:DtAdhGroup/@V)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p>
                                 </td>
                                 <td width="13.5%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                    <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($ligne/n:CodModFinanc/@V)"/></span></p>
                                 </td>
                                 <td width="15.7%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                    <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtFinancOrgGroup/@V"/></xsl:call-template></span></p>
                                 </td>
                              </tr>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm7">
                           <xsl:choose>
                              <xsl:when test="count($varOdm6/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="100%" colspan="4" rowspan="1" style="border-top:hidden;border-left: double black 1.5pt;border-bottom:solid black 1.0pt;border-right: double black 1.5pt;padding:0in 3.55pt 0in 3.55pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm6"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm7/xhtml:tr"/>
                        </xsl:call-template>
                        <tr style="page-break-inside:avoid">
                           <td width="100%" colspan="4" style="border-top:none;border-left: double black 1.5pt;border-bottom:solid black 1.0pt;border-right: double black 1.5pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif">Autres organismes de regroupement</span></b></p>
                              
                           </td>
                        </tr><xsl:variable name="varOdm8" select="$varOdm1[(./n:CodNatOrgGroup/@V='09')]"/>
                        <xsl:variable name="varOdm9">
                           <xsl:for-each select="$varOdm8"><xsl:sort select="./n:DtAdhGroup/@V"/><xsl:variable name="ligne" select="."/>
                              <tr style="page-break-inside:avoid">
                                 <td width="58.6%" style="border-top:none;border-left:double black 1.5pt; border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                    <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($ligne/n:NomOrgGroup/@V)"/></span></p>
                                 </td>
                                 <td width="12.2%" style="border-top:none;border-left:none; border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                    <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($ligne/n:DtAdhGroup/@V)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p>
                                 </td>
                                 <td width="13.5%" style="border-top:none;border-left:none; border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                    <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:value-of select="distinct-values($ligne/n:CodModFinanc/@V)"/></span></p>
                                 </td>
                                 <td width="15.7%" style="border-top:none;border-left:none; border-bottom:double black 1.5pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                    <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&quot;Arial&quot;,sans-serif"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/n:MtFinancOrgGroup/@V"/></xsl:call-template></span></p>
                                 </td>
                              </tr>
                           </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="varOdm10">
                           <xsl:choose>
                              <xsl:when test="count($varOdm9/*) = 0">
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    <td height="1px" width="100%" colspan="4" rowspan="1" style="border-top:hidden;border-left: double black 1.5pt;border-bottom:double black 1.5pt;border-right: double black 1.5pt;padding:0in 3.55pt 0in 3.55pt"/>
                                 </tr>
                              </xsl:when>
                              <xsl:otherwise>
                                 <xsl:sequence select="$varOdm9"/>
                              </xsl:otherwise>
                           </xsl:choose>
                        </xsl:variable>
                        <xsl:call-template name="table:processRowBorders">
                           <xsl:with-param name="borderStyle" select="'none'"/>
                           <xsl:with-param name="rows" select="$varOdm10/xhtml:tr"/>
                        </xsl:call-template>
                     </table>
                  </xsl:variable>
                  <xsl:call-template name="table:outputTable">
                     <xsl:with-param name="table" select="$varOdmTmpTab2"/>
                  </xsl:call-template>
                  
               </div>
               
               <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif"> </span></p>
               
               <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&quot;Arial&quot;,sans-serif">(1) Indiquer si le financement est fait par TPZ, TPU, TPU + fiscalité additionnelle ou sans fiscalité propre.</span></p>
               
            </div></body></html>
   </xsl:template></xsl:stylesheet>